package treeNAlgo;

import treeN.*;

/**
 * Splits host upwards if its state &gt; order and passes the host to the
 * supplied param, which is an ISpliceCmd, to do some "abstract splicing".
 * @dependency treeNAlgo.ILambda uses
 */
class SplitUpAndApply<E> implements ITreeNAlgo<E, TreeN<E>, ILambda<TreeN<E>, TreeN<E>>> {
  
  private int _order;
  /**
   * Installs no-op cmd for states <= order
   */
  public SplitUpAndApply(int order) {
    _order = order;
  }
  
  public TreeN<E> caseAt(Integer s, TreeN<E> host, ILambda<TreeN<E>, TreeN<E>>... cmd) {
    if (s <= _order) {
      return host;
    }
    else {
      host.splitUpAt(s/2);   // push data up
      return cmd[0].apply(host); // "splice" host into something!
    }
  }
  
}

